#include <stdbool.h>
#include <stdio.h>
#include <Windows.h>
#include "cliparse.h"

HINSTANCE h_module;

typedef bool(__cdecl* enumerate_devices)(void);
typedef char* (__cdecl* path)(int);
typedef void(__cdecl* set_active_device_by_path)(char*);
typedef void(__cdecl* set_active_device_by_index)(int);
typedef char* (__cdecl* info)(void);
typedef int(__cdecl* count)(void);
typedef void(__cdecl* set_attenuation)(int,double);
typedef void(__cdecl* set_attenuations)(double*);
typedef void(__cdecl* set_all_attenuations)(double);
typedef int(__cdecl *status)(int*);
typedef bool(__cdecl* bool_func)(void);

#define GETFUNC(DESC,NAME) (DESC)GetProcAddress(h_module, NAME)

const CMD_DESCRIPTOR commandsTable[] =
{
	/************************************
			ATTENUATOR COMMANDS
	************************************/
	{CMD_STR_SELECT_DEVICE,		CommandSelect,			"Select the device"},
	{CMD_STR_SET_ATTEN,         CommandSet,             "Set an attenuator"},
	{CMD_STR_SET_ALL_ATTEN,     CommandSaa,             "Set all attenuators"},
	{CMD_STR_STATUS,            CommandStatus,          "Get all attenuations"},

	/************************************
			  MISC COMMANDS
   ************************************/
   {CMD_STR_INFO,              CommandInfo,            "Get info about the device"},
   {CMD_STR_HELP,              CommandHelp,            "Print help"},
};

int GetCommandsCount()
{
	return sizeof(commandsTable) / sizeof(*commandsTable);
}

void PrintHelp()
{
	printf("\r\n");
	printf("Hit CTRL+C or type 'quit' to exit\r\n");
	printf("\r\n");

	int commandsCount = GetCommandsCount();
	for (int i = 0; i < commandsCount; i++)
		printf("   %s - %s\r\n", commandsTable[i].cmdStr, commandsTable[i].cmdDescr);
	printf("\r\n");
}

int CommandSelect(int argc, char** argv)
{
	if (argc == 2)
	{
		int index = atoi(argv[1]);
		if (index >= 0)
		{
			set_active_device_by_index select = GETFUNC(set_active_device_by_index, "SetActiveDevice");
			select(index);
			return 1;
		}
	}
	printf("\r\nERROR!\r\n");
	return 0;
}

int CommandSet(int argc, char** argv)
{
	if (argc == 3)
	{
		int channel = atoi(argv[1]);
		float value = atof(argv[2]);
		set_attenuation set = GETFUNC(set_attenuation, "SetAttenuation");
		set(channel, value);
		return 1;
	}
	printf("\r\nERROR!\r\n");
	return 0;
}

int CommandSaa(int argc, char** argv)
{
	if (argc == 2)
	{
		float value = atof(argv[1]);
		set_all_attenuations saa = GETFUNC(set_all_attenuations, "SetAllAttenuations");
		saa(value);
		return 1;
	}
	else if (argc > 2)
	{
		int channelscount = (int)GETFUNC(count, "GetChannelsCount")();
		if (argc == channelscount + 1)
		{
			float *values = malloc(channelscount * sizeof(float));
			for (int i = 0; i < channelscount; i++)
			{
				values[i] = atof(argv[1 + i]);
			}
			set_attenuations set = GETFUNC(set_attenuations, "SetAttenuations");
			set(values);
			return 1;
		}
	}
	printf("\r\nERROR!\r\n");
	return 0;
}

int CommandStatus(int argc, char** argv)
{
	status stat = GETFUNC(status, "GetAttenuations");
	int a = 0;
	int chCount = stat((float*)&a);
	float *atten_val = (float*)a;
	printf("\r\n");
	for (int i = 0; i < chCount; i++)
	{
		printf("Channel %d: %.2f\r\n", i + 1, atten_val[i]);
	}
	return 1;
}

int CommandInfo(int argc, char** argv)
{
	info getmodel = GETFUNC(info, "GetModel");
	info getserial = GETFUNC(info, "GetSerial");
	info getfwver = GETFUNC(info, "GetFirmwareVersion");
	info getfwdate = GETFUNC(info, "GetFirmwareDate");
	info getblver = GETFUNC(info, "GetBootloaderVersion");
	info getmfgdate = GETFUNC(info, "GetManufactDate");

	info getip = GETFUNC(info, "GetIPAddress");
	info getmask = GETFUNC(info, "GetSubnet");
	info getgw = GETFUNC(info, "GetGateway");
	bool netstatus = (bool)GETFUNC(bool_func, "GetNetworkStatus")();
	bool dhcp = (bool)GETFUNC(bool_func, "GetDHCPState")();

	printf("\r\n---- Device Information ----"
		"\r\nModel: %s"
		"\r\nSN: %s"
		"\r\nFW Ver: %s"
		"\r\nFW Date: %s"
		"\r\nBL Ver: %s"
		"\r\nMFG Date: %s\r\n", getmodel(), getserial(), getfwver(), getfwdate(), getblver(), getmfgdate());

	printf("\r\n---- TCP/IP Information ----"
		"\r\nStatus: %s"
		"\r\nIP Address: %s"
		"\r\nSubnet: %s"
		"\r\nGateway: %s"
		"\r\nDHCP: %s\r\n", netstatus ? "Connected" : "Disconnected", getip(), getmask(), getgw(), dhcp ? "Enabled" : "Disabled");
}

int CommandHelp(int argc, char** argv)
{
	PrintHelp();
	return 1;
}

int ParseCommand(char *cmd)
{
	if (!strcmp(cmd, "quit") || !strcmp(cmd, "q"))
		return -1;
	else
		return CommandParse(cmd);
}

int main(void)
{
	printf("Adaura Control Attenuator Test Program\n");
	h_module = LoadLibrary(L"AdauraControlLib.dll");

	if (h_module)
	{
		info getversion = GETFUNC(info, "Version");
		printf("Dll loaded successfully. Version \"%s\"\n", getversion());
		printf("Detecting connected devices...\n");

		bool devicesenumerated = GETFUNC(enumerate_devices, "EnumerateDevices")();

		if (devicesenumerated)
		{
			int devicescount = (int)GETFUNC(count, "GetDevicesCount")();
			printf("%d device(s) found\n", devicescount);

			for (int i = 0; i < devicescount; ++i)
			{
				printf("Connected device %d:\n", i);

				path p = GETFUNC(path, "GetDevicePath");
				char* device_path = p(i);

				printf("\tDevice path: %s\n", device_path);

				set_active_device_by_path setdevice = GETFUNC(set_active_device_by_path, "SetActiveDeviceByPath");
				setdevice(device_path);

				info getinfo = GETFUNC(info, "GetSerial");
				char* serialno = getinfo();
				printf("\tSerial No: %s\n", serialno);

				getinfo = GETFUNC(info, "GetModel");
				char* model = getinfo();
				printf("\tModel: %s\n", model);

				int channelscount = (int)GETFUNC(count, "GetChannelsCount")();
				printf("\tChannels count: %d\n", channelscount);
			}
			set_active_device_by_index select = GETFUNC(set_active_device_by_index, "SetActiveDevice");
			select(0);

			while (1)
			{
				printf("\r\n# ");
				char str[CMD_MAX_LENGTH] = { 0 };
				gets(str);
				
				if (ParseCommand(str) == -1)
					return 0;

			}
		}
		else
		{
			printf("No connected devices found\n");
		}
		
		FreeLibrary(h_module);
	}
	else printf("Error loading DLL\n");

	return 0;
}
